/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import noppes.npcs.api.CommandNoppesBase;
import noppes.npcs.controllers.FactionController;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.data.Faction;
import noppes.npcs.controllers.data.PlayerData;
import noppes.npcs.controllers.data.PlayerFactionData;

public class CmdFaction
extends CommandNoppesBase {
    public List<PlayerData> data;
    public Faction selectedFaction;

    @Override
    public int func_82362_a() {
        return 2;
    }

    @CommandNoppesBase.SubCommand(desc="Add points", usage="<points>", permission=2)
    public void add(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int points;
        try {
            points = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            throw new CommandException(args[0] + " must be an integer", new Object[0]);
        }
        int factionId = this.selectedFaction.id;
        for (PlayerData playerdata : this.data) {
            PlayerFactionData playerfactiondata = playerdata.factionData;
            playerfactiondata.increasePoints(playerdata.player, factionId, points);
            sender.func_145747_a((ITextComponent)new TextComponentString(points + " points added to player \"" + playerdata.playername + "\" Faction ID: " + factionId));
            playerdata.save(true);
        }
    }

    @CommandNoppesBase.SubCommand(desc="Drop relationship", permission=2)
    public void drop(MinecraftServer server, ICommandSender sender, String[] args) {
        for (PlayerData playerdata : this.data) {
            playerdata.factionData.factionData.remove(this.selectedFaction.id);
            sender.func_145747_a((ITextComponent)new TextComponentString("Player \"" + playerdata.playername + "\" has Faction ID: " + this.selectedFaction.id + " removed"));
            playerdata.save(true);
        }
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args == null) {
            return;
        }
        String playername = args[0];
        String factionName = args[1];
        this.data = PlayerDataController.instance.getPlayersData(sender, playername);
        if (this.data.isEmpty()) {
            throw new CommandException("Unknown player " + playername, new Object[0]);
        }
        try {
            this.selectedFaction = FactionController.instance.getFaction(Integer.parseInt(factionName));
        }
        catch (NumberFormatException e) {
            this.selectedFaction = FactionController.instance.getFactionFromName(factionName);
        }
        if (this.selectedFaction == null) {
            throw new CommandException("Unknown faction " + factionName, new Object[0]);
        }
        this.executeSub(server, sender, args[2], Arrays.copyOfRange(args, 3, args.length));
    }

    @Override
    public String getDescription() {
        return "Faction operations";
    }

    @Override
    @Nonnull
    public String func_71517_b() {
        return "faction";
    }

    @Nonnull
    public List<String> func_184883_a(@Nonnull MinecraftServer server, @Nonnull ICommandSender par1, @Nonnull String[] args, BlockPos pos) {
        if (args.length == 3) {
            return CommandBase.func_71530_a((String[])args, (String[])new String[]{"add", "subtract", "set", "reset", "drop", "create"});
        }
        return new ArrayList<String>();
    }

    @Override
    public String getUsage() {
        return "<player> <faction> <command>";
    }

    @CommandNoppesBase.SubCommand(desc="Reset points to default", permission=2)
    public void reset(MinecraftServer server, ICommandSender sender, String[] args) {
        for (PlayerData playerdata : this.data) {
            playerdata.factionData.factionData.put(this.selectedFaction.id, this.selectedFaction.defaultPoints);
            playerdata.save(true);
        }
    }

    @Override
    public boolean runSubCommands() {
        return false;
    }

    @CommandNoppesBase.SubCommand(desc="Set points", usage="<points>", permission=2)
    public void set(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int points;
        try {
            points = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            throw new CommandException(args[0] + " - must be an integer", new Object[0]);
        }
        for (PlayerData playerdata : this.data) {
            PlayerFactionData playerfactiondata = playerdata.factionData;
            playerfactiondata.factionData.put(this.selectedFaction.id, points);
            playerdata.save(true);
        }
    }

    @CommandNoppesBase.SubCommand(desc="Subtract points", usage="<points>", permission=2)
    public void subtract(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        int points;
        try {
            points = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException ex) {
            throw new CommandException("Must be an integer", new Object[0]);
        }
        int factionId = this.selectedFaction.id;
        for (PlayerData playerdata : this.data) {
            PlayerFactionData playerfactiondata = playerdata.factionData;
            playerfactiondata.increasePoints(playerdata.player, factionId, -points);
            playerdata.save(true);
        }
    }
}

